import os
import signal
import sys
import traceback

import Foundation
import PyObjCTools.KeyValueCoding

import cxlog

if cxlog.is_on() or 'DEBUG' in os.environ:
    import PyObjCTools.Debugging
    PyObjCTools.Debugging.installPythonExceptionHandler()


def dump_stacks(sig, frame):
    for tid, tframe in sys._current_frames().items():
        stack = traceback.format_stack(tframe)
        if len(stack) > 0:
            Foundation.NSLog("Thread %@:", tid)
            for line in stack:
                Foundation.NSLog('%@', line)

signal.signal(signal.SIGINFO, dump_stacks)
