# GstElement

The `GstElement` is the most important object in the entire GStreamer system,
as it defines the structure of the pipeline. Elements include: sources,
filters, sinks, and containers (Bins). They may be an intrinsic part of
the core GStreamer library, or may be loaded from a plugin. In some
cases they’re even fabricated from completely different systems (see the
LADSPA plugin). Elements are generally created from a `GstElementFactory`,
which will be covered in another chapter, but for the intrinsic types
they can be created with specific functions.

Elements contain `GstPads` (also covered in another chapter), which are
subsequently used to connect the Elements together to form a pipeline
capable of passing and processing data. They have a parent, which must
be another Element. This allows deeply nested pipelines, and the
possibility of "black-box" meta-elements.

## Name

All elements are named, and while their names should ideally be unique in any
given pipeline, they do not have to be. The only guaranteed unique name
for an element is its complete path in the object hierarchy. In other
words, an element’s name is unique inside its parent (This follows from
`GstObject`’s name explanation). This uniqueness is guaranteed through
all functions where either the parentage or name of an element is changed.

## Pads

`GstPads` are the property of a given `GstElement`. They provide the
connection capability allowing arbitrary structure in the graph.
Every `GstElement` (with the exception of sources and sinks) have at
least 2 `GstPad`s. These pads are stored in a single `GList` within the
Element. Several counters are kept in order to allow quicker
determination of the type and properties of a given Element.

Pads may be added to an element with `_add_pad()`. Retrieval is done via
`_get_static_pad()`, which operates on the name of the Pad (the unique
key). This means that all Pads owned by a given Element must have unique
names. A pointer to the `GList` of pads may be obtained with
`_iterate_pads()`.

`gst_element_add_pad(element,pads)`: Sets the element as the parent of
the pad, then adds the pad to the element’s list of pads, keeping the
counts of total, src, and sink pads up to date. Emits the `new_pad`
signal with the pad as argument. Fails if either the element or pad are
NULL or not what they claim to be. Should fail if the pad already
has a parent. Should fail if the pad is already owned by the element.
Should fail if there’s already a pad by that name in the list of pads.

`pad = gst_element_get_pad(element, "padname")`: Searches through the
list of pads

## Ghost Pads

More info in [ghostpad](additional/design/gstghostpad.md).

## State

An element has a state. More info in [state](additional/design/states.md).
